package jcircus.exceptions;

import java.io.*;

/**
 * A generic application exception, compatible with Java versions prior
 * to 1.4.
 *
 * This code has been released into the public domain and may be used
 * for any purposes whatsoever without acknowledgment.
 *
 * @author Malcolm Sparks
 */
public class JCircusException extends RuntimeException {
    
    Throwable cause;
    
    public JCircusException(String msg) {
        super(msg);
    }
    
    public JCircusException(String msg, Throwable cause) {
        super(msg);
        this.cause = cause;
    }
    
    public Throwable getCause() {
        return this.cause;
    }
    
    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            System.out.println("Caused by:");
            this.cause.printStackTrace();
        }
    }
    
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.cause != null) {
            s.println("Caused by:");
            this.cause.printStackTrace(s);
        }
    }
    
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.cause != null) {
            s.println("Caused by:");
            this.cause.printStackTrace(s);
        }
    }
    
    public String getMessage() {
        if (this.cause == null) {
            return super.getMessage();
        } else {
            return super.getMessage() + " (see below for lower-level details)";
        }
    }
    
}

